/* Run entire model and store stochastic results*/

/*PRELIMINARIES*/

/*Directories*/
/*global Dir "C:/Users/eilya/Principal Economics/PE - NZTA - RLTDM/Stata/MS1"*/
/*global Dir "C:/Users/eilya/Principal Economics/PE - Stata/MS1"*/
global Dir "C:/Users/eilya/Principal Economics/PE - Stata/RLTDM AUG23"
global InputDir `"/Input/"'
global OutputDir `"Output/"'
global MacroStochasticOutputFN `"EconStochasticResults.xlsx"'
global TransportStochasticOutputFN `"TransportStochasticResults.xlsx"'
global ScenarioOutputFN `"BaseScenarioResults_Aug2020.xlsx"'

/*Data*/
cd "${Dir}"
do "Loading data from excel.do"
cd "${Dir}"
do "Functions_RLTDM.do"
mata
/*Set mode, scenario = 0, sensitivity = 1*/
mode = 0
/*For sensitivity/monte carlo mode, choose number of simulations - NB: 20
*sims and 20 output percentiles take long (a few hours) to complete*/
runs = 20
/*number of percentiles to be outputted from the sims, note that the excel output sheets are set up to receive 20 (increments of 5*) percentiles*/
output_p = 20 
/*Write output to excel - 0 to avoid writing output to excel*/
write = 1
/*Specify if a projected tax rate growth series is provided*/
specify_tax = 1
    
/*DIMENSIONS
*Projection length, periods*/
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050
*Length of historical data series*/
Ts = 1992
Te = 2020
/*History_t = 1992:2020
*Set population series length, history plus projection
*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length
/*Length of history
*History_length = length(History_t)*/
History_length = Te - Ts
HL = History_length

/*Length of projection
*Projection_length = length(Projection_t)*/
Projection_length = Pe - Ps

/*Set number of age groups and variable for k-1 (ages)
*Ages = 0:100*/
Ages_n = 101
k_minus_one = Ages_n-1

/* set number of regions
*Reg_n = 1:12*/
Regl = 12
/*Reg_str = ['NOR''AKL''WAI''BOP''TAR''MAN''WEL''CAN''OTG''STH''GIS''USI']
*Industries
*Ind = 1:17 *Includes Unallocated*/
Ind_n = 17
/*Indx = 16 //Excludes Unallocated*/
Indx_n = 16

/*Transport model industries, includes Unallocated NLTDM_Ind = 9 */
NLTDM_Ind_n = 9
/*Transport model industriesExcludes Unallocated Freight_ind = 1:8 */
Freight_ind_n = 8

/* order or regions and industries*/
nor = 1
akl = 2
wai = 3
bop = 4
tar = 5
man = 6
wel = 7
can = 8
otg = 9
sth = 10
gis = 11
usi = 12

ag = 1
othp = 2
manf = 3
con = 4
whl = 5
rtl = 6
afb = 7
trn = 8
fin = 9
rent = 10
ood = 11
prof = 12
pub = 13
edu = 14
hlth = 15
oths = 16
unal = 17
end


mata
/*Initialise output variables*/
if (mode ==1) {
/*National stochastic variables to be tracked*/

/*Socioeconomics*/
pop_mc = J(Time_length,runs,0)
pop_workage_mc = J(Time_length,runs,0)
gdp_vol_fcast_mc = J(Time_length,runs,0)
gdp_percapita_mc = J(Time_length,runs,0)
lf_tot_mc = J(Time_length,runs,0)
netm_fcast_mc = J(Time_length,runs,0)
immigr_fcast_mc = J(Time_length,runs,0)
os_emigr_tot_mc = J(Time_length,runs,0)

pop_pcnt = J(Time_length,output_p,0)
pop_workage_pcnt = J(Time_length,output_p,0)
gdp_vol_fcast_pcnt = J(Time_length,output_p,0)
gdp_percapita_pcnt = J(Time_length,output_p,0)
lf_tot_pcnt = J(Time_length,output_p,0)
netm_fcast_pcnt = J(Time_length,output_p,0)
immigr_fcast_pcnt = J(Time_length,output_p,0)
os_emigr_tot_pcnt = J(Time_length,output_p,0)

gdp_ind_vol_fcast_mc= J(Time_length,Ind_n*runs,0)
gdp_ind_vol_fcast_pcnt = J(Time_length,Ind_n*output_p,0)

/*Transport */

lite_veh_proj_total_mc = J(Time_length,runs,0)
vkt_tot_mc = J(Time_length,runs,0)
petrol_pump_pricer_mc = J(Time_length,runs,0) 
co2_total_mc = J(Time_length,runs,0)
tax_tot_r_mc = J(Time_length,runs,0)
freight_vol_fcast_mc = J(Time_length,runs,0)
roadfreight_vol_share_mc = J(Time_length,runs,0)
roadfreight_tkm_fcast_mc = J(Time_length,runs,0)
passkm_tot_mc = J(Time_length,runs,0)
passkm_pt_tot_mc = J(Time_length,runs,0)
vehicles_per_pop_mc = J(Time_length,runs,0) 
vehicles_per_hh_mc = J(Time_length,runs,0)
cyc_tot_mc = J(Time_length,runs,0)
walk_tot_mc = J(Time_length,runs,0)

hcv_proj_total_mc = J(Time_length,runs,0)
bus_proj_total_mc = J(Time_length,runs,0)
hcv_vkt_total_mc = J(Time_length,runs,0)
bus_vkt_total_mc = J(Time_length,runs,0)

nltf_real_mc = J(Time_length,runs,0)
net_nltf_real_mc = J(Time_length,runs,0)
ruc_real_mc = J(Time_length,runs,0)
fed_real_mc = J(Time_length,runs,0)

lite_veh_proj_total_p = J(Time_length,output_p,0)
vkt_tot_p = J(Time_length,output_p,0)
petrol_pump_price_proj_r_p = J(Time_length,output_p,0) 
co2_total_p = J(Time_length,output_p,0)
tax_tot_r_p = J(Time_length,output_p,0)
freight_vol_fcast_p = J(Time_length,output_p,0)
roadfreight_vol_share_p = J(Time_length,output_p,0)
roadfreight_tkm_fcast_p = J(Time_length,output_p,0)
passkm_tot_p = J(Time_length,output_p,0)
passkm_pt_tot_p = J(Time_length,output_p,0)
vehicles_per_pop_p = J(Time_length,output_p,0) 
vehicles_per_hh_p = J(Time_length,output_p,0)
cyc_tot_p = J(Time_length,output_p,0)
walk_tot_p = J(Time_length,output_p,0)

hcv_proj_total_p = J(Time_length,output_p,0)
bus_proj_total_p = J(Time_length,output_p,0)
hcv_vkt_total_p = J(Time_length,output_p,0)
bus_vkt_total_p = J(Time_length,output_p,0)

nltf_real_p = J(Time_length,output_p,0)
net_nltf_real_p = J(Time_length,output_p,0)
ruc_real_p = J(Time_length,output_p,0)
fed_real_p = J(Time_length,output_p,0)
}
/*Regional stochastic variables to be tracked*/

/*Socioeconomics*/
mata

hh_inc_reg_mc= J(Time_length,Regl*runs, 0)
pop_by_reg_mc = J(Time_length,Regl*runs, 0)
reg_lf_mc = J(Time_length,Regl*runs, 0)
reg_employment_mc = J(Time_length,Regl*runs, 0)
reg_households_mc = J(Time_length,Regl*runs, 0)
reg_gnp_mc = J(Time_length,Regl*runs, 0)
reg_gdp_mc = J(Time_length,Regl*runs, 0)


nor_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
akl_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
wai_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
bop_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
tar_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
man_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
wel_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
can_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
otg_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
sth_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
gis_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)
usi_reg_ind_gdp_mc = J(Time_length,Indx_n*runs,0)

/*Transport*/
reg_veh_mc = J(Time_length,Regl*runs, 0)
reg_vkt_mc = J(Time_length,Regl*runs, 0)
reg_pt_mc = J(Time_length,Regl*runs, 0)
reg_freight_mc = J(Time_length,Regl*runs, 0)
reg_cyc_proj_mc = J(Time_length,Regl*runs, 0)
reg_walk_proj_mc = J(Time_length,Regl*runs, 0)

hh_inc_reg_p = J(Time_length,Regl*output_p, 0)
pop_by_reg_p = J(Time_length,Regl*output_p, 0)
reg_lf_p = J(Time_length,Regl*output_p, 0)
reg_employment_p = J(Time_length,Regl*output_p, 0)
reg_households_p = J(Time_length,Regl*output_p, 0)
reg_gnp_p = J(Time_length,Regl*output_p, 0)
reg_gdp_p = J(Time_length,Regl*output_p, 0)

nor_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
akl_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
wai_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
bop_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
tar_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
man_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
wel_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
can_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
otg_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
sth_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
gis_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)
usi_reg_ind_gdp_p = J(Time_length,Indx_n*output_p,0)


/*Transport*/
reg_veh_pcnt = J(Time_length,Regl*output_p, 0)
reg_vkt_p = J(Time_length,Regl*output_p, 0)
reg_pt_p = J(Time_length,Regl*output_p, 0)
reg_freight_p = J(Time_length,Regl*output_p, 0)
reg_cyc_proj_p = J(Time_length,Regl*output_p, 0)
reg_walk_proj_p = J(Time_length,Regl*output_p, 0)


/*A. ASSUMPTIONS to be varied by scenario or stochastic simulation*/


/*A.1 Population and labour markets*/

/*A.1.1 National inward migration assumptions*/
/*Stochastic Parameters*/
immigr_stdev_param = 0.075631 /*standard deviation from a VEC model of arrivals, departures and GDE per capita (previous value from detrended series 0.116482)*/
/*Trend*/
immigr_g_param = 1.005 
migr_nonlin = (1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,1,1,1,1)

/*migr_nonlin = (.0623,	-.09,	-.0875,	-.140,	-.23,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,	1,1,1,1,1)*/

/*A.1.1 National and interregional outward migration assumptions*/
p_emigr_stdev_param = 0.072156 /*standard deviation from a VEC model of arrivals, departures and GDE per capita (previous value from detrended series 0.134929)*/
p_emigr_g_param =1.00
p_emigr_cyc = (J(HL,1,0)', 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)

/*p_emigr_cyc = (J(HL,1,0)', -0.28,-0.18,-0.082,-0.027,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)*/


/*A.1.3 National employment*/
/*Assumed national long run unemployment rate*/
/* Time to reach long run unemployment rate*/
lr_unemployment_rate = 0.045 
lr_unemployment_adjustment_speed = 10
emp_cycle = (J(HL,1,1) \ 1	\0.95	\0.93	\.915	\0.91	\0.95	\0.98	\1	\1\	1\	1	\1	\1\	1	\1	\1	\1\	1	\1	\1\	1\	1\	1\	1\	1	\1\1\1\1\1)

/* A.1.3.1 Logistic parameters for lfpr
//long run level
//long run level
//smoothing parameter
//timing of end point */
										
lfpr_f_star = (0.50\0.70\0.74\0.74\0.74\0.8\0.82\0.83\0.86\0.82\0.34)
lfpr_m_star = (0.50\0.80\0.90\0.93\0.93\0.93\0.93\0.92\0.90\0.84\0.34)
lfpr_b =(0.30\.30\.30\.30\.30\.30\.30\.30\.30\.30\.3)
lfpr_v =(2\2\2\2\2\2\2\2\2\2\2)
lfpr_S = (3\2\2\2\2\2\2\2\2\2\2) 
lfpr_T =(2018\2030\2040\2040\2040\2040\2040\2040\2040\2040\2040) 

/*A.1.4 Regional employment*/
reg_lr_unemployment_rate = (0.072, 0.045, 0.048, 0.061, 0.044, 0.046, 0.041, 0.040, 0.04, 0.031, 0.057, 0.031) //Assumed variable unemployment rates
reg_lr_unemployment_adjspeed = 10 //Regionalised\time to reach NAIRU - assumed same for all regions

/*A.1.5 Interregional migration shock -- applied to p_emigr_dest*/
immigr_shk = (1,1,1,1,1,1,1,1,1,1,1,1,1)
immigr_shk_t = 2020

/*A.2 Industry and income outlook*/

/*A.2.1 National economic growth
//1+ MFP annual growthh rate assumption (1// = low)*/
tot_mfp = 1.01 
tot_mfp_stdev = 0.016:*mode
mfp_cycle = (J(HL,1,0) \-.012\-0.004\0.00\0.006\0.0052\00.003\0.002\00.001\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0)

/*A.2.2 Industry GDP shares

//BAU uses a VAR to project industry GDP. This model can be adjusted with the following level shift shocks (//X changes in output by industry 
//i.e. 0.1 shock 10// increase in sector production). Note that this does not necessarily produce a sustained //X change in industry GDP. 
//The impact of the shock is attenuated by flow on impacts on other
//industries the fact that total national production is not allowed to grow as a result of these
//shocks.//Shocks are also defined by when they occuring during the
//projection period - hence */

ag_shock = 0
othp_shock = -0.07
man_shock = 0
con_shock = 0
whl_shock = 0
rtl_shock = 0
afb_shock = 0
trn_shock = 0
fin_shock = 0
rent_shock = 0
ood_shock = 0
prof_shock = 0
pub_shock = 0
edu_shock = 0
hlth_shock = 0
oths_shock = 0

ag_shock_t = 23
othp_shock_t = 25
man_shock_t = 23
con_shock_t = 23
whl_shock_t = 23
rtl_shock_t = 23
afb_shock_t = 23
trn_shock_t = 23
fin_shock_t = 23
rent_shock_t = 23
ood_shock_t = 23
prof_shock_t = 23
pub_shock_t = 23
edu_shock_t = 23
hlth_shock_t = 23
oths_shock_t = 23

/*A.2.3 Industry MFP growth (in the form of 1+g(j), where g(j) is industries j's
//assumed MFP growth rate.
//(BAU assumptions for industry based on average growth 1996-2010)*/
ag_mfp = 1.01220743950141
othp_mfp = 0.981148761571173
man_mfp = 1.00600817767933
con_mfp = 1.00342781429627
whl_mfp = 1.01608150268074
rtl_mfp = 1.01189866539449
afb_mfp = 0.992074327722143
trn_mfp = 1.00931049407065
fin_mfp = 1.01787877280595
rent_mfp = 1.01545850595931
ood_mfp = 1.000
prof_mfp = 0.993418402124081
pub_mfp = 0.999811470574526
edu_mfp = 0.988498670885361
hlth_mfp = 1.00821727306525
oths_mfp = 1.01273967812184

/*A.3 Freight demand
//A.3.1 Freight intensity growth (i.e. growth in freight use per unit of
//volume GDP)
//A.3.1.1 Road freight*/
ag_roadfreight_intensity_growth = 1.0
for_roadfreight_intensity_growth = 1.0
min_roadfreight_intensity_growth = 1.0
othm_roadfreight_intensity_gr = 1.00
cons_roadfreight_intensity_gr = 1.0
trad_roadfreight_intensity_gr = 1.0
oths_roadfreight_intensity_gr = 1.0
pub_roadfreight_intensity_gr = 1.0

/*A.3.1.2 Rail freight*/
ag_railfreight_intensity_growth = 1.0
for_railfreight_intensity_growth = 1.00
min_railfreight_intensity_growth = 1.0
othm_railfreight_intensity_gr = 1.00
cons_railfreight_intensity_gr = 1.00
trad_railfreight_intensity_gr = 1.00
oths_railfreight_intensity_gr =1.000
pub_railfreight_intensity_gr = 1.0

/*A.3.1.3 Sea freight*/
ag_seafreight_intensity_growth = 1.0
for_seafreight_intensity_growth = 1.00
min_seafreight_intensity_growth = 1.0
othm_seafreight_intensity_gr = 1.0
cons_seafreight_intensity_gr = 1.00
trad_seafreight_intensity_gr = 1.0
oths_seafreight_intensity_gr =1.000
pub_seafreight_intensity_gr = 1.0


/*A.5 Prices

//A.5.1 Macro assumptions

//A.5.1.1 CPI*/
cpi_growth = 0.02

/*A.5.1.2 NZD vs USD exchange rate (1 stdev = +/-12//)*/
nzd_usd_er_lr = 0.68
nzd_usd_er_smooth = 5
/* exchange rate random departures from trend - this is an input to the random normal function for nzd_usd_er_e*/
nzd_usd_er_e_stdev = 0.12*mode

/*A.5.2 Fuel cost 

//A.5.2.1 USD oil price*/
oil_price_lr = 275 //https://www.iea.org/reports/oil-market-report-december-2019 at ex rate usd63 = nzd107.5 //This is nominal. $275 approximates the IEA WEO 2012 ($140 in 2011 dollars plus 3// inflation reflecting expected high inflation post QE).
oil_price_lr_smooth = 20 //Time period over which price tends towards lr
oil_e_stdev = 0.2*mode //oil random departures from trend(1 stdev = +/- 20//)

/*A.5.2.2 Electric vehicle efficiency and cost */
elec_eff_initial = 0.2 // In 2020 this has not changed: assume 20 kWh per 100km - apparently the leaf is around 19 kWh per 100km but I've added a little more to account for bigger cars 
elec_price_initial = 0.325 // 2020 increased from .28 to .325: averaeg price used for simplicity - any analysis for eg distribution pricing would need to adopt a different approach to discount fixed costs
elec_price_growth = 0.01 //Real - CPI growth added on in prices model
elec_tax = 0 //Set to 1 to turn on nltf taxes on electric vehicle travel - when = 1 assumes they track excise. 

/*A.5.3 Emissions prices and taxes (used as input to prices)*/
real_excise_tax_growth = 0.00
real_ets_cost_growth = 0.005
petrol_tax_growth = cpi_growth + real_excise_tax_growth 
diesel_tax_growth = cpi_growth + real_excise_tax_growth
track_length = 11
petrol_tax_track = (J(1,History_length,0), 0.059377721,0.056049623,0.0530748,0.026131725,0.023453692,0.019910102,0.020247736,0.02,0.02,0.02,0.02,J(1,Time_length-History_length-track_length, petrol_tax_growth))
diesel_tax_track = (J(1,History_length,0),0.06,0.05,0.06,0.03,0.02,0.02,0.02,0.02,0.02,0.02,0.02, J(1,Time_length-History_length-track_length,petrol_tax_growth))
ets_cost_growth = cpi_growth + real_ets_cost_growth
gst_constant = 0.15

/*A.5.3.1 Local taxes //NOTE THERE ARE ISSUES HERE RE CCHANGING THE TIMING -
//NEED TO CHECK...(not an error as long as set at 2015)*/
local_tax_year_introduced = 2020
intial_local_tax_by_reg = (0,0,0,0,0,0,0,0,0,0,0,0) //nor, akl, wai, bop,tar, man, wel, can...
local_tax_rate_of_increase = (0,0,0,0,0,0,0,0,0,0,0,0) //real rate


/*A.5.4 Road user charges

//A.5.4.1 Light vehicles*/
real_light_ruc_growth = 0.0
lpv_ruc_rate_growth = cpi_growth + real_light_ruc_growth 
lcv_ruc_rate_growth = lpv_ruc_rate_growth 

/*A.5.4.2 Heavy vehicles*/
real_heavy_ruc_growth = 0.0
hcv_ruc_rate_growth = cpi_growth + real_heavy_ruc_growth 
bus_ruc_rate_growth = cpi_growth + real_heavy_ruc_growth 

/*A.6 Vehicle technology assumptions and age assumptions

//A.6.1 Light Passenger Vehicles

//A.6.1.1 New Vehicle purchases*/
lpv_new_reg_shr_gdp_coeff = -1.858 //share registrations that are new - elasticity w.r.t gdp per capita
lpv_new_reg_shr_price_coeff = -1.71 //share registrations that are new - elasticity w.r.t cpi deflated new vehicle price index

/*A.6.1.2 Growth in used vehicle import ages (1+rate) */
lpv_used_age_g = 0.99 //central growth path
lpv_used_age_sigma = 0.01 //stochastic component

/*A.6.1.3 Long run shares of alternative vehicles in registrations
//Equn is: lpv_reg_share(t) = lpv_reg_share(t-1) + (Target-lpv_reg_share(t-1))/(1+S.e^-b(t-T))^(1/v)*/

lpv_alt_target = .25 //Target level share
lpv_alt_T = 30 //Time of maximum penetration (can be a period inside or outside the model - i.e. scenarios for high rates of penetration in, say 100 years)
lpv_alt_S = 2
lpv_alt_b = 0.3
lpv_alt_v = lpv_alt_S

lpv_reg_electric_target_shr = 0.5 //Share of taregt alternative fuel vehicles which are electric vehicles
lpv_reg_plugin_target_shr = 0.1 //Share of taregt alternative fuel vehicles which are plug-in hybrid vehicles  
/*Share of taregt alternative fuel vehicles which are hybrid vehicles*/
lpv_reg_hybrid_target_shr = 1-(lpv_reg_electric_target_shr +lpv_reg_plugin_target_shr) 
lpv_plugin_T = 30 //Time to target share of plug-in hybrid vehicles (hybrids are a residual)
lpv_electric_T = 30 //Time to target share of electric vehicles (hybrids are a residual)

/*A.6.2 Light Commercial Vehicles

//A.6.2.1 New Vehicle purchases*/
lcv_new_reg_shr_gdp_coeff = -2.247 //share registrations that are new - elasticity w.r.t gdp per capita
lcv_new_reg_shr_price_coeff = -1.1752 //share registrations that are new - elasticity w.r.t cpi deflated new vehicle price index


/*A.6.2.2 Growth in used vehicle import ages (1+rate) */
lcv_used_age_g = 1.01  //central growth path
lcv_used_age_sigma = 0.01 //stochastic component

/*A.6.2.3 Long run shares of alternative vehicles in registrations
//NOTE: this is included with some cautiousness given the vitrual absence of
//alternative fuel vehicles in this space but we assume it could be
//rectified
//Equn is: lcv_reg_share(t) = lcv_reg_share(t-1) + (Target-lcv_reg_share(t-1))/(1+S.e^-b(t-T))^(1/v)*/
lcv_alt_target = 0.1 //Target level share
lcv_alt_T = 30 //Time of maximum penetration (can be a period inside or outside the model - i.e. scenarios for high rates of penetration in, say 100 years)
lcv_alt_S = 2
lcv_alt_b = 0.3
lcv_alt_v = lcv_alt_S

lcv_reg_hybrid_target_shr = 0.4//Share of taregt alternative fuel vehicles which are hybrid vehicles  
lcv_reg_plugin_target_shr = 0.1 //Share of taregt alternative fuel vehicles which are plug-in hybrid vehicles  
lcv_reg_electric_target_shr = 0.5 //Share of taregt alternative fuel vehicles which are electric vehicles
lcv_plugin_T = 30 //Time to target share of alternative fuelled vehicles
lcv_electric_T = 30 //Time to target share of alternative fuelled vehicles

/*A.6.3 Trends in overall fleet fuel efficiency improvement*/
eff_exog_improvement = 0.998

/*A.7 Travel demand

//A.7.1 Regional variations in Vehicle and private passenger kilometres travelled 

//A.7.1.1 Underlying regional VKT growth relative to national average*/
nor_vkt_dist_growth = 1
akl_vkt_dist_growth = 1
wai_vkt_dist_growth = 1
bop_vkt_dist_growth = 1
tar_vkt_dist_growth = 1
man_vkt_dist_growth = 1
wel_vkt_dist_growth = 1
can_vkt_dist_growth = 1
otg_vkt_dist_growth = 1
sth_vkt_dist_growth = 1
gis_vkt_dist_growth = 1
usi_vkt_dist_growth = 1

/*A.7.1.2 Growth in average private vehicle occupancy*/
nor_occ_growth = 1
akl_occ_growth = 1
wai_occ_growth = 1
bop_occ_growth = 1
tar_occ_growth = 1
man_occ_growth = 1
wel_occ_growth = 1
can_occ_growth = 1
otg_occ_growth = 1
sth_occ_growth = 1
gis_occ_growth = 1
usi_occ_growth = 1

/*A.7.2 Regional (underlying) growth in Public Transport demand

//A.7.2.1 Autonomous growth in PT kilometres per passenger*/
nor_pt_km_growth = 1
akl_pt_km_growth = 1
wai_pt_km_growth = 1
bop_pt_km_growth = 1
tar_pt_km_growth = 1
man_pt_km_growth = 1
wel_pt_km_growth = 1
can_pt_km_growth = 1
otg_pt_km_growth = 1
sth_pt_km_growth = 1
gis_pt_km_growth = 1
usi_pt_km_growth = 1

/*A.7.2.2 Autonomous growth in PT passenger numbers per capita*/
nor_pt_pas_growth = 1
akl_pt_pas_growth = 1       
wai_pt_pas_growth = 1
bop_pt_pas_growth = 1
tar_pt_pas_growth = 1
man_pt_pas_growth = 1
wel_pt_pas_growth = 1
can_pt_pas_growth = 1
otg_pt_pas_growth = 1
sth_pt_pas_growth = 1
gis_pt_pas_growth = 1
usi_pt_pas_growth = 1

/*A.7.2.3 Timing of autonomus growth in PT passenger numbers per capita
//(assumed here to be common across any shock in terms of the timing of
//implementation and the region, though this could be easily changed).
//Here the shock is implement in 2013 and does not reach full effect until
//2023, although the increase is accelerating.*/
shock_timing = (J(13,1,0),0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,0.95,J(19,1,1))

/*shock_timing = [zeros(13,1)0.10.20.40.8ones(25,1)]
// A.6.2.4 Autonomous growth in cycling per capita*/
nor_cyc_growth = 1
akl_cyc_growth = 1
wai_cyc_growth = 1
bop_cyc_growth = 1
tar_cyc_growth = 1
man_cyc_growth = 1
wel_cyc_growth = 1
can_cyc_growth = 1
otg_cyc_growth = 1
sth_cyc_growth = 1
gis_cyc_growth = 1
usi_cyc_growth = 1

/* A.6.2.2 Autonomous growth in walking per capita*/
nor_walk_growth = 1
akl_walk_growth = 1
wai_walk_growth = 1
bop_walk_growth = 1
tar_walk_growth = 1
man_walk_growth = 1
wel_walk_growth = 1
can_walk_growth = 1
otg_walk_growth = 1
sth_walk_growth = 1
gis_walk_growth = 1
usi_walk_growth = 1

/*A.7.3 VKT elasticities

//A.7.3.1 Light passenger vehicles*/
lpv_vkt_cost_elasticity = -0.20
lpv_vkt_income_elasticity = 0.008

/*A.7.3.2 Light commercial vehicles*/
lcv_vkt_cost_elasticity = -0.1
lcv_vkt_income_elasticity = 0.01

/*A.7.3.3 Motorcycles*/
mc_vkt_cost_elasticity = -0.01
mc_vkt_income_elasticity = 0.01

/*A.7.3.4 Heavy Commercial Vehicles (not needed but included for
//completeness)*/
hcv_vkt_cost_elasticity = 0
hcv_vkt_income_elasticity = 0

/*A.7.3.5 Bus (not needed but included for
//completeness)*/
bus_vkt_cost_elasticity = 0.005
bus_vkt_income_elasticity = -0.001

/*A.7.3.6 Passkm elast (not used to produce results but used to approximate
//price effects after the fact)
// passkm_price_elast = 0.02 //(a purchasing power elasticity)

//A.7.4 Public transport (PT) passenger demand elasticities*/
pt_fuel_price_elast = 0.5
pt_inc_elasticity = -0.001

/*A.8 Travel demand scenarios
//A.8.1 Density multiplier 
//Density grows with population but this variable can be used in scenario to
//mimic densiification for a given population growth*/
nor_dens = 1
akl_dens = 1
wai_dens = 1
bop_dens = 1
tar_dens = 1
man_dens = 1
wel_dens = 1
can_dens = 1
otg_dens = 1
sth_dens = 1
gis_dens = 1
usi_dens = 1
/* Note the alphabetical order for the travel model*/
density_scenario = (akl_dens,bop_dens,can_dens,gis_dens,man_dens,nor_dens,otg_dens, sth_dens,tar_dens,usi_dens,wai_dens,wel_dens)
density_scenario_fwd = J(59,6,density_scenario)
/*A.8.2 Congestion multiplier */
/*Speed doesnt changebut this variable can be used in scenario to
//mimic congestion or supply side shocks by shifting speeds up and down.*/
nor_speed = 1 
akl_speed = 1
wai_speed = 1
bop_speed = 1
tar_speed = 1
man_speed = 1
wel_speed = 1
can_speed = 1
otg_speed = 1
sth_speed = 1
gis_speed = 1
usi_speed = 1
/* Note the alphabetical order for the travel model*/
speed_scenario = (akl_speed,bop_speed,can_speed,gis_speed,man_speed,nor_speed, otg_speed, sth_speed,tar_speed,usi_speed,wai_speed,wel_speed)
speed_scenario_fwd = J(TL,6,speed_scenario)

/*A.8.3 PT (train and bus) costs relative to driver travel*/
nor_pt_price = 0 /*BAU assumption is -1// (slower) than driving (High = 0, Low = -2) */
akl_pt_price = 0
wai_pt_price = 0
bop_pt_price = 0
tar_pt_price = 0
man_pt_price = 0
wel_pt_price = 0
can_pt_price = 0
otg_pt_price = 0
sth_pt_price = 0
gis_pt_price = 0
usi_pt_price = 0

pt_price_scenario = (nor_pt_price,akl_pt_price,wai_pt_price,bop_pt_price,gis_pt_price,tar_pt_price,man_pt_price, wel_pt_price,usi_pt_price,can_pt_price,otg_pt_price,sth_pt_price)

pt_price_scenario_fwd  = J(TL,6,pt_price_scenario)

nor_bus_exog_rate = 1 //Candidate values 1, 
akl_bus_exog_rate = 0.99 //Candidate values 0.97, 0.99, 1
wai_bus_exog_rate = 0.99 //Candidate values 0.95, 0.97, 1
bop_bus_exog_rate = 0.99 //Candidate values 0.95, 0.97, 1
tar_bus_exog_rate = 0.99 //Candidate values 0.95, 0.97, 1
man_bus_exog_rate = 0.99 //Candidate values 0.95, 0.97, 1
wel_bus_exog_rate = 0.99 //Candidate values 0.95, 0.97, 1
can_bus_exog_rate = 0.98 //Candidate values 0.95, 0.97, 1
otg_bus_exog_rate = 0.98 //Candidate values 0.95, 0.97, 1
sth_bus_exog_rate = 0.98 //Candidate values 0.95, 0.97, 1
gis_bus_exog_rate = 0.99 //Candidate values 0.95, 0.97, 1
usi_bus_exog_rate = 0.99 //Candidate values 0.95, 0.97, 1

bus_exog_rate = (nor_bus_exog_rate,akl_bus_exog_rate,wai_bus_exog_rate,bop_bus_exog_rate,gis_bus_exog_rate,tar_bus_exog_rate,man_bus_exog_rate, wel_bus_exog_rate,usi_bus_exog_rate,can_bus_exog_rate,otg_bus_exog_rate,sth_bus_exog_rate)

bus_exog_adjustment_speed = (1..30)' /*[51015202530313233343536] */
nor_train_exog_rate = 2 
akl_train_exog_rate = 2 /* This ensures that train travel doesn't go crazy - the lower the value the less crazy. 2 seems good*/
wai_train_exog_rate = 2 
bop_train_exog_rate = 2 
tar_train_exog_rate = 2 
man_train_exog_rate = 2 
wel_train_exog_rate = 2 
can_train_exog_rate = 2 
otg_train_exog_rate = 2 
sth_train_exog_rate = 2 
gis_train_exog_rate = 2 
usi_train_exog_rate = 2

train_exog_rate = (nor_train_exog_rate,akl_train_exog_rate,wai_train_exog_rate,bop_train_exog_rate,gis_train_exog_rate,tar_train_exog_rate,man_train_exog_rate, wel_train_exog_rate,usi_train_exog_rate,can_train_exog_rate,otg_train_exog_rate,sth_train_exog_rate)

train_exog_rate = bus_exog_rate + (1:-bus_exog_rate):/train_exog_rate 
train_exog_adjustment_speed = (1..30)' /*[51015202530313233343536]        */       

/*A.8.3 Growth in driver (standardised)journey times */
nor_drive_time = 1 /*Low = 0.99, //Medium = 1 , High = 1.01 */
akl_drive_time = 1.1 /*Low = 1.0, //Medium = 1.02 , High = 1.05 */
wai_drive_time = 1 /*Low = 0.99, //Medium = 1 , High = 1.01*/
bop_drive_time = 1 /*Low = 0.99, //Medium = 1 , High = 1.01*/
tar_drive_time = 1.01 /*Low = 1.0, //Medium = 1.01 , High = 1.05*/
man_drive_time = 1.005  /*Low = 1.0, //Medium = 1.005 , High = 1.05*/
wel_drive_time = 1 /*Low = 0.99, //Medium = 1 , High = 1.025*/
can_drive_time = 1.01 /*Low = 1.0, //Medium = 1.01 , High = 1.05*/
otg_drive_time = 1 /*Low = 0.99, //Medium = 1 , High = 1.01*/
sth_drive_time = 1 /*Low = 0.99, //Medium = 1 , High = 1.01*/
gis_drive_time = 1 /*Low = 0.99, //Medium = 1 , High = 1.01*/
usi_drive_time = 1 /*Low = 1, //Medium = 1.01 , High = 1.025*/

drive_time_scenario = (nor_drive_time,akl_drive_time,wai_drive_time,bop_drive_time,gis_drive_time,tar_drive_time,man_drive_time, wel_drive_time,usi_drive_time,can_drive_time,otg_drive_time,sth_drive_time)

/*drive_time_scenario_fwd  = repmat(drive_time_scenario,TL,1,6)

A.9 Household income distribution shock*/

/*CHECKING STATA
OK "Population.do"
OK "Growth_and_incomes.do"
OK "HH_vehicle_demand.do"
OK "Freight demand.do"
OK numbers need another check "Prices.do"
Model OK, lpv OK, lcv numbers incorret "Vehicle_fleet.do"
do "VKT_and_cost.do"
do "HH_travel.do"
*/
hh_inc_shk = 1
st_local("mode", strofreal(mode))
st_local("runs", strofreal(runs))
st_local("write", strofreal(write))
end
if (`mode'==0){
do "Population.do"
do "Growth_and_incomes.do"
do "HH_vehicle_demand.do"
do "Freight demand.do"
do "Prices.do"
do "Vehicle_fleet.do"
do "VKT_and_cost.do"
do "HH_travel.do"
}
else{
    forval z=1(1)`runs'{
		
	    do "Population.do"
		do "Growth_and_incomes.do"
		do "HH_vehicle_demand.do"
		do "Freight demand.do"
		do "Prices.do"
		do "Vehicle_fleet.do"
		do "VKT_and_cost.do"
		do "HH_travel.do"
		matrix z0 = `z'
		mata: z = st_matrix("z0")
		mata: z
		mata: pop_mc[.,z] = pop[.,1]
		mata: pop_workage_mc[.,z] = pop_workage[.,1]
		mata: gdp_vol_fcast_mc[.,z] = gdp_vol_fcast[.,1]
		mata: gdp_percapita_mc[.,z] = gdp_percapita[.,1]
		mata: lf_tot_mc[.,z] = lf_tot[.,1]
		mata: netm_fcast_mc[.,z] = netm_fcast[.,1]
		mata: immigr_fcast_mc[.,z] = immigr_fcast[.,1]
		mata: os_emigr_tot_mc[.,z] = os_emigr_tot[.,1]
		mata: gdp_ind_vol_fcast_mc[.,(z-1)*Ind_n+1..z*Ind_n] = gdp_ind_vol_fcast

		mata: hh_inc_reg_mc[.,(z-1)*j_r+1..z*j_r] = hh_inc_reg
		mata: pop_by_reg_mc[.,(z-1)*j_r+1..z*j_r] = pop_by_reg
		mata: reg_lf_mc[.,(z-1)*j_r+1..z*j_r]= reg_lf
		mata: reg_employment_mc[.,(z-1)*j_r+1..z*j_r]= reg_employment
		mata: reg_households_mc[.,(z-1)*j_r+1..z*j_r]= reg_households
		mata: reg_gnp_mc[.,(z-1)*j_r+1..z*j_r]= reg_gnp
		mata: reg_gdp_mc[.,(z-1)*j_r+1..z*j_r]= reg_gdp

		mata: nor_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,0*Indx_n+1..1*Indx_n]
		mata: akl_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,1*Indx_n+1..2*Indx_n]
		mata: wai_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,2*Indx_n+1..3*Indx_n]
		mata: bop_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,3*Indx_n+1..4*Indx_n]
		mata: tar_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,4*Indx_n+1..5*Indx_n]
		mata: man_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,5*Indx_n+1..6*Indx_n]
		mata: wel_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,6*Indx_n+1..7*Indx_n]
		mata: can_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,7*Indx_n+1..8*Indx_n]
		mata: otg_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,8*Indx_n+1..9*Indx_n]
		mata: sth_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,9*Indx_n+1..10*Indx_n]
		mata: gis_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,10*Indx_n+1..11*Indx_n]
		mata: usi_reg_ind_gdp_mc[.,(z-1)*Indx_n+1..z*Indx_n]= reg_ind_gdp[.,11*Indx_n+1..12*Indx_n]

		mata: lite_veh_proj_total_mc[.,z] = lite_veh_proj_total[.,1]
		mata: vkt_tot_mc[.,z] = vkt_tot[.,1]
		mata: petrol_pump_pricer_mc[.,z] = petrol_pump_price_proj_r[.,1] 
		mata: co2_total_mc[.,z] = co2_total[.,1]
		mata: tax_tot_r_mc[.,z] = tax_tot_r[.,1]
		mata: freight_vol_fcast_mc[.,z] = freight_vol_fcast[.,1]
		mata: roadfreight_vol_share_mc[.,z] = roadfreight_vol_share[.,1]
		mata: roadfreight_tkm_fcast_mc[.,z] = roadfreight_tkm_fcast[.,1]
		mata: passkm_tot_mc[.,z] = passkm_tot[.,1]
		mata: passkm_pt_tot_mc[.,z] = passkm_pt_tot[.,1]
		mata: vehicles_per_pop_mc[.,z] = vehicles_per_pop[.,1] 
		mata: vehicles_per_hh_mc[.,z]= vehicles_per_hh[.,1]
		mata: cyc_tot_mc[.,z]= cyc_tot
		mata: walk_tot_mc[.,z]= walk_tot
		
		mata: hcv_proj_total_mc[.,z] = hcv_proj_total[.,1]
		mata: bus_proj_total_mc[.,z] = bus_proj_total[.,1]
		mata: hcv_vkt_total_mc[.,z] = hcv_vkt_total[.,1]
		mata: bus_vkt_total_mc[.,z] = bus_vkt_total[.,1]

		mata: nltf_real_mc[.,z] = nltf_real[.,1]
		mata: net_nltf_real_mc[.,z] = net_nltf_real[.,1]
		mata: fed_real_mc[.,z] = fed_real[.,1]
		mata: ruc_real_mc[.,z] = ruc_real[.,1]

		mata: pop_by_reg_mc[.,(z-1)*j_r+1..z*j_r] = pop_by_reg

		mata: reg_veh_mc[.,(z-1)*j_r+1..z*j_r] = veh_reg
		mata: reg_vkt_mc[.,(z-1)*j_r+1..z*j_r]= reg_vkt_proj_re
		mata: reg_pt_mc[.,(z-1)*j_r+1..z*j_r]= reg_pt_passkm_proj
		mata: reg_freight_mc[.,(z-1)*j_r+1..z*j_r]= reg_roadfreight_fcast
		mata: reg_cyc_proj_mc[.,(z-1)*j_r+1..z*j_r]= reg_cyc_proj
		mata: reg_walk_proj_mc[.,(z-1)*j_r+1..z*j_r]= reg_walk_proj
	}
}


if (`mode'==1){
mata
    /*Calculate results*/

	/*Regional percentiles*/
	hh_inc_reg_mc_sorted = J(TL,j_r*runs,0)
	pop_by_reg_mc_sorted = J(TL,j_r*runs,0)
	reg_lf_mc_sorted = J(TL,j_r*runs,0)
	reg_employment_mc_sorted = J(TL,j_r*runs,0)
	reg_households_mc_sorted = J(TL,j_r*runs,0)
	reg_gnp_mc_sorted = J(TL,j_r*runs,0)
	reg_gdp_mc_sorted = J(TL,j_r*runs,0)
	reg_veh_mc_sorted = J(TL,j_r*runs,0)
	reg_vkt_mc_sorted = J(TL,j_r*runs,0)
	reg_pt_mc_sorted = J(TL,j_r*runs,0)
	reg_freight_mc_sorted = J(TL,j_r*runs,0)
	reg_cyc_proj_mc_sorted = J(TL,j_r*runs,0)
	reg_walk_proj_mc_sorted = J(TL,j_r*runs,0)
	
for (i = 1; i<=12; i++) {
	for (r = 1; r<=runs; r++) {
	hh_inc_reg_mc_sorted[.,(i-1)*runs+r] = hh_inc_reg_mc[.,(r-1)*Regl+i]
	pop_by_reg_mc_sorted[.,(i-1)*runs+r] = pop_by_reg_mc[.,(r-1)*Regl+i]
	reg_lf_mc_sorted[.,(i-1)*runs+r] = reg_lf_mc[.,(r-1)*Regl+i]
	reg_employment_mc_sorted[.,(i-1)*runs+r] = reg_employment_mc[.,(r-1)*Regl+i]
	reg_households_mc_sorted[.,(i-1)*runs+r] = reg_households_mc[.,(r-1)*Regl+i]
	reg_gnp_mc_sorted[.,(i-1)*runs+r] = reg_gnp_mc[.,(r-1)*Regl+i]
	reg_gdp_mc_sorted[.,(i-1)*runs+r] = reg_gdp_mc[.,(r-1)*Regl+i]
	reg_veh_mc_sorted[.,(i-1)*runs+r] = reg_veh_mc[.,(r-1)*Regl+i]
	reg_vkt_mc_sorted[.,(i-1)*runs+r] = reg_vkt_mc[.,(r-1)*Regl+i]
	reg_pt_mc_sorted[.,(i-1)*runs+r] = reg_pt_mc[.,(r-1)*Regl+i]
	reg_freight_mc_sorted[.,(i-1)*runs+r] = reg_freight_mc[.,(r-1)*Regl+i]
	reg_cyc_proj_mc_sorted[.,(i-1)*runs+r] = reg_cyc_proj_mc[.,(r-1)*Regl+i]
	reg_walk_proj_mc_sorted[.,(i-1)*runs+r] = reg_walk_proj_mc[.,(r-1)*Regl+i]
	}
	hh_inc_reg_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(hh_inc_reg_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	pop_by_reg_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(pop_by_reg_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_lf_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_lf_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_employment_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_employment_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_households_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_households_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_gnp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_gnp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_veh_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_veh_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_vkt_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_vkt_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_pt_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_pt_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_freight_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_freight_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_cyc_proj_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_cyc_proj_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	reg_walk_proj_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(reg_walk_proj_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
}

	/*National values*/

	pop_mc_sorted = sort(pop_mc',TL)'
	pop_workage_mc_sorted = sort(pop_workage_mc',TL)'
	gdp_vol_fcast_mc_sorted = sort(gdp_vol_fcast_mc',TL)'
	gdp_percapita_mc_sorted = sort(gdp_percapita_mc',TL)'
	lf_tot_mc_sorted = sort(lf_tot_mc',TL)'
	netm_fcast_mc_sorted = sort(netm_fcast_mc',TL)'
	immigr_fcast_mc_sorted = sort(immigr_fcast_mc',TL)'
	os_emigr_tot_mc_sorted = sort(os_emigr_tot_mc',TL)'

	lite_veh_proj_total_mc_sorted = sort(lite_veh_proj_total_mc',TL)' 
	vkt_tot_mc_sorted = sort(vkt_tot_mc',TL)'
	petrol_pump_pricer_mc_sorted = sort(petrol_pump_pricer_mc',TL)'
	co2_total_mc_sorted = sort(co2_total_mc',TL)'
	tax_tot_r_mc_sorted = sort(tax_tot_r_mc',TL)'
	freight_vol_fcast_mc_sorted = sort(freight_vol_fcast_mc',TL)'
	roadfreight_vol_share_mc_sorted = sort(roadfreight_vol_share_mc',TL)'
	roadfreight_tkm_fcast_mc_sorted = sort(roadfreight_tkm_fcast_mc',TL)'
	passkm_tot_mc_sorted = sort(passkm_tot_mc',TL)'
	passkm_pt_tot_mc_sorted = sort(passkm_pt_tot_mc',TL)'
	vehicles_per_pop_mc_sorted = sort(vehicles_per_pop_mc',TL)'
	vehicles_per_hh_mc_sorted = sort(vehicles_per_hh_mc',TL)'
	cyc_tot_mc_sorted = sort(cyc_tot_mc',TL)'
	walk_tot_mc_sorted = sort(walk_tot_mc',TL)'

	hcv_proj_total_mc_sorted = sort(hcv_proj_total_mc',TL)'
	bus_proj_total_mc_sorted = sort(bus_proj_total_mc',TL)'
	hcv_vkt_total_mc_sorted = sort(hcv_vkt_total_mc',TL)'
	bus_vkt_total_mc_sorted = sort(bus_vkt_total_mc',TL)'

	nltf_real_mc_sorted = sort(nltf_real_mc',TL)'
	net_nltf_real_mc_sorted = sort(net_nltf_real_mc',TL)'
	ruc_real_mc_sorted = sort(ruc_real_mc',TL)'
	fed_real_mc_sorted = sort(fed_real_mc',TL)'
	
	/*Industry numbers*/
	gdp_ind_vol_fcast_mc_sorted = J(TL,Ind_n*runs,0)
	nor_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	akl_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	wai_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	bop_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	tar_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	man_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	wel_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	can_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	otg_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	sth_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	gis_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	usi_reg_ind_gdp_mc_sorted = J(TL,Ind_n*runs,0)
	
	for (i = 1; i<=Indx_n; i++) {
		for (r = 1; r<=runs; r++) {
			nor_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = nor_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			akl_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = akl_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			wai_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = wai_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			bop_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = bop_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			tar_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = tar_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			man_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = man_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			wel_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = wel_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			can_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = can_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			otg_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = otg_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			sth_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = sth_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			gis_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = gis_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
			usi_reg_ind_gdp_mc_sorted[.,(i-1)*runs+r] = usi_reg_ind_gdp_mc[.,(r-1)*Indx_n+i]
		}
		nor_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(nor_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		akl_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(akl_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		wai_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(wai_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		bop_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(bop_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		tar_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(tar_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		man_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(man_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		wel_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(wel_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		can_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(can_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		otg_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(otg_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		sth_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(sth_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		gis_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(gis_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		usi_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(usi_reg_ind_gdp_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
	}
		for (i = 1; i<=Ind_n; i++) {
			for (r = 1; r<=runs; r++) {
				gdp_ind_vol_fcast_mc_sorted[.,(i-1)*runs+r] = gdp_ind_vol_fcast_mc[.,(r-1)*Indx_n+i]
			}
			gdp_ind_vol_fcast_mc_sorted[.,(i-1)*runs+1..i*runs] = sort(gdp_ind_vol_fcast_mc_sorted[.,(i-1)*runs+1..i*runs]',TL)'
		}
			
	end
}
/*C. Write output to MS Excel
C.1. Macroeconomic and population results
C.1.1 Prep_output files with headers and prep output data with date columns*/

 /*   NatOutput = (Time_t',pop,pop_workage,households,people_per_hh,pop_dependent_ratio,gdp_vol_fcast,gdp_percapita,lf_growth,mfp_growth,gdp_ind_vol_fcast,freight_vol_fcast, roadfreight_tkm_fcast,railfreight_vol_share, seafreight_vol_share,freight_intensity,hcv_proj_total,veh,vehicles_per_pop,vehicles_per_hh,vkt_tot,vkt_per_veh,lite_average_fuel_efficiency_o,lite_alt_fuel_veh_shr_o,lite_alt_fuel_reg_shr_o , bus_proj_total, oil_price_proj_r,petrol_pump_price_proj_r,tax_tot_r,co2_total,nltf_real,net_nltf_real,ruc_real,fed_real)*/
/*C.1.3 Write data*/
if (`write' ==1 & `mode' ==1){
	mata
	
	lf_tot_pcnt = lf_tot_mc_sorted
	pop_pcnt = pop_mc_sorted
	pop_workage_pcnt = pop_workage_mc_sorted
	gdp_percapita_pcnt = gdp_percapita_mc_sorted
	gdp_vol_fcast_pcnt = gdp_vol_fcast_mc_sorted
	hh_inc_reg_p = hh_inc_reg_mc_sorted
	pop_by_reg_p =  pop_by_reg_mc_sorted
	reg_lf_p =  reg_lf_mc_sorted
    reg_employment_p =  reg_employment_mc_sorted
    reg_households_p =  reg_households_mc_sorted
    reg_gnp_p =  reg_gnp_mc_sorted
    reg_gdp_p =  reg_gdp_mc_sorted
    
	gdp_ind_vol_fcast_pcnt =  gdp_ind_vol_fcast_mc_sorted
    nor_reg_ind_gdp_p = nor_reg_ind_gdp_mc_sorted
    akl_reg_ind_gdp_p = akl_reg_ind_gdp_mc_sorted
    wai_reg_ind_gdp_p = wai_reg_ind_gdp_mc_sorted
    bop_reg_ind_gdp_p = bop_reg_ind_gdp_mc_sorted
    tar_reg_ind_gdp_p = tar_reg_ind_gdp_mc_sorted
    man_reg_ind_gdp_p = man_reg_ind_gdp_mc_sorted
    wel_reg_ind_gdp_p = wel_reg_ind_gdp_mc_sorted
    can_reg_ind_gdp_p = can_reg_ind_gdp_mc_sorted
    otg_reg_ind_gdp_p = otg_reg_ind_gdp_mc_sorted
    sth_reg_ind_gdp_p = sth_reg_ind_gdp_mc_sorted
    gis_reg_ind_gdp_p = gis_reg_ind_gdp_mc_sorted
    usi_reg_ind_gdp_p = usi_reg_ind_gdp_mc_sorted

	netm_fcast_pcnt = netm_fcast_mc_sorted 
	immigr_fcast_pcnt = immigr_fcast_mc_sorted
	os_emigr_tot_pcnt = os_emigr_tot_mc_sorted 
	
    reg_veh_pcnt =  reg_veh_mc_sorted
    reg_vkt_p =  reg_vkt_mc_sorted
    reg_pt_p =  reg_pt_mc_sorted
    reg_freight_p =  reg_freight_mc_sorted
    reg_cyc_proj_p =  reg_cyc_proj_mc_sorted
    reg_walk_proj_p =  reg_walk_proj_mc_sorted
	
	lite_veh_proj_total_p = lite_veh_proj_total_mc_sorted 
	vkt_tot_p = vkt_tot_mc_sorted
	petrol_pump_price_proj_r_p = petrol_pump_pricer_mc_sorted
	co2_total_p = co2_total_mc_sorted
	tax_tot_r_p = tax_tot_r_mc_sorted
	freight_vol_fcast_p = freight_vol_fcast_mc_sorted
	roadfreight_vol_share_p = roadfreight_vol_share_mc_sorted
	roadfreight_tkm_fcast_p = roadfreight_tkm_fcast_mc_sorted
	passkm_tot_p = passkm_tot_mc_sorted 
	passkm_pt_tot_p = passkm_pt_tot_mc_sorted
	vehicles_per_pop_p = vehicles_per_pop_mc_sorted
	vehicles_per_hh_p = vehicles_per_hh_mc_sorted
	cyc_tot_p = cyc_tot_mc_sorted
	walk_tot_p = walk_tot_mc_sorted

	hcv_proj_total_p = hcv_proj_total_mc_sorted
	bus_proj_total_p = bus_proj_total_mc_sorted
	hcv_vkt_total_p = hcv_vkt_total_mc_sorted
	bus_vkt_total_p = bus_vkt_total_mc_sorted

	nltf_real_p = nltf_real_mc_sorted
	net_nltf_real_p = net_nltf_real_mc_sorted
	ruc_real_p = ruc_real_mc_sorted
	fed_real_p = fed_real_mc_sorted
	
	b = xl() 
	b.load_book("${Dir}/Output/${MacroStochasticOutputFN}")
	sheets = b.set_sheet("LabourForceNZ")
	b.put_number(3,3,lf_tot_pcnt)
	sheets = b.set_sheet("PopulationNZ")
	b.put_number(3,3,pop_pcnt)
	sheets = b.set_sheet("GDPPerCapitaNZ")
	b.put_number(3,3,gdp_percapita_pcnt)
	sheets = b.set_sheet("WorkingAgePopNZ")
	b.put_number(3,3,pop_workage_pcnt)
	sheets = b.set_sheet("GDPVolNZ")
	b.put_number(3,3,gdp_vol_fcast_pcnt)
	sheets = b.set_sheet("HHincomeReg")
	b.put_number(3,3,hh_inc_reg_p)
	sheets = b.set_sheet("PopulationReg")
	b.put_number(3,3,pop_by_reg_p)
	
	sheets = b.set_sheet("LabourForceReg")
	b.put_number(3,3,reg_lf_p)
	sheets = b.set_sheet("EmploymentReg")
	b.put_number(3,3,reg_employment_p)
	sheets = b.set_sheet("HHReg")
	b.put_number(3,3,reg_households_p)
	sheets = b.set_sheet("GNPReg")
	b.put_number(3,3,reg_gnp_p)
	sheets = b.set_sheet("GDPReg")
	b.put_number(3,3,reg_gdp_p)
	sheets = b.set_sheet("IndGDPNZ")
	b.put_number(3,3,lf_tot_pcnt)
	
	sheets = b.set_sheet("NorthlandIndGDP")
	b.put_number(3,3,nor_reg_ind_gdp_p)
	sheets = b.set_sheet("AucklandIndGDP")
	b.put_number(3,3,akl_reg_ind_gdp_p)
	sheets = b.set_sheet("WaikatoIndGDP")
	b.put_number(3,3,wai_reg_ind_gdp_p)
	sheets = b.set_sheet("BayofPlentyIndGDP")
	b.put_number(3,3,bop_reg_ind_gdp_p)
	sheets = b.set_sheet("TaranakiIndGDP")
	b.put_number(3,3,tar_reg_ind_gdp_p)
	sheets = b.set_sheet("ManawatuIndGDP")
	b.put_number(3,3,man_reg_ind_gdp_p)
	sheets = b.set_sheet("WellingtonIndGDP")
	b.put_number(3,3,wel_reg_ind_gdp_p)
	sheets = b.set_sheet("CanterburyIndGDP")
	b.put_number(3,3,can_reg_ind_gdp_p)
	sheets = b.set_sheet("OtagoIndGDP")
	b.put_number(3,3,otg_reg_ind_gdp_p)
	sheets = b.set_sheet("SouthlandIndGDP")
	b.put_number(3,3,sth_reg_ind_gdp_p)
	sheets = b.set_sheet("GisborneIndGDP")
	b.put_number(3,3,gis_reg_ind_gdp_p)
	sheets = b.set_sheet("UpperSthIslandIndGDP")
	b.put_number(3,3,usi_reg_ind_gdp_p)
	
	sheets = b.set_sheet("NetmigrationNZ")
	b.put_number(3,3,netm_fcast_pcnt)
	sheets = b.set_sheet("ImmigrationNZ")
	b.put_number(3,3,immigr_fcast_pcnt)
	sheets = b.set_sheet("EmigrationNZ")
	b.put_number(3,3,os_emigr_tot_pcnt)

	b.load_book("${Dir}/Output/${TransportStochasticOutputFN}")
	sheets = b.set_sheet("VehiclesByRegion")
	b.put_number(3,3,reg_veh_pcnt)
	sheets = b.set_sheet("VktByRegion")
	b.put_number(3,3,reg_vkt_p)
	sheets = b.set_sheet("PtByRegion")
	b.put_number(3,3,reg_pt_p)
	sheets = b.set_sheet("FreightByRegion")
	b.put_number(3,3,reg_freight_p)
	sheets = b.set_sheet("RegCycleKm")
	b.put_number(3,3,reg_cyc_proj_p)
	sheets = b.set_sheet("RegWalkKm")
	b.put_number(3,3,reg_walk_proj_p)
	
	sheets = b.set_sheet("LightVehiclesNZ")
	b.put_number(3,3,lite_veh_proj_total_p)
	sheets = b.set_sheet("VktNZ")
	b.put_number(3,3,vkt_tot_p)
	sheets = b.set_sheet("PetrolPricePumpReal")
	b.put_number(3,3,petrol_pump_price_proj_r_p)
	sheets = b.set_sheet("CO2")
	b.put_number(3,3,co2_total_p)
	sheets = b.set_sheet("TaxReal")
	b.put_number(3,3,tax_tot_r_p)
	sheets = b.set_sheet("FreightVol")
	b.put_number(3,3,freight_vol_fcast_p)
	sheets = b.set_sheet("RoadFreightVolShare")
	b.put_number(3,3,roadfreight_vol_share_p)
	sheets = b.set_sheet("RoadFreightVolTKM")
	b.put_number(3,3,roadfreight_tkm_fcast_p)
	sheets = b.set_sheet("PassengerKm")
	b.put_number(3,3,passkm_tot_p)
	sheets = b.set_sheet("PassengerKmPT")
	b.put_number(3,3,passkm_pt_tot_p)
	sheets = b.set_sheet("VehiclesPerCapita")
	b.put_number(3,3,vehicles_per_pop_p)
	sheets = b.set_sheet("VehiclesPerHH")
	b.put_number(3,3,vehicles_per_hh_p)
	sheets = b.set_sheet("HeavyVehicles")
	b.put_number(3,3,hcv_proj_total_p)
	sheets = b.set_sheet("Busses")
	
	b.put_number(3,3,bus_proj_total_p)
	sheets = b.set_sheet("HeavyVKT")
	b.put_number(3,3,hcv_vkt_total_p)
	sheets = b.set_sheet("BusVKT")
	b.put_number(3,3,bus_vkt_total_p)
	sheets = b.set_sheet("CycleKm")
	b.put_number(3,3,cyc_tot_p)
	sheets = b.set_sheet("WalkKm")
	b.put_number(3,3,walk_tot_p)
	
	sheets = b.set_sheet("NLTF_real")
	b.put_number(3,3,nltf_real_p)
	sheets = b.set_sheet("NLTF_real_net")
	b.put_number(3,3,net_nltf_real_p)
	sheets = b.set_sheet("FED_real")
	b.put_number(3,3,fed_real_p)
	sheets = b.set_sheet("RUC_real")
	b.put_number(3,3,ruc_real_p)
	end
}
if ((`write' ==1) & (`mode' ==0)){
	mata
    lite_average_fuel_efficiency_o=(J(9,1,0)\lite_average_fuel_efficiency)

	lite_alt_fuel_veh_shr_o=(J(8,1,0)\lite_alt_fuel_veh_shr)
	lite_alt_fuel_reg_shr_o=(J(8,1,0)\lite_alt_fuel_reg_shr)
	
    NatOutput = (Time_t',pop,pop_workage,households,people_per_hh,pop_dependent_ratio,gdp_vol_fcast,gdp_percapita,lf_growth,mfp_growth,gdp_ind_vol_fcast,freight_vol_fcast, roadfreight_tkm_fcast,railfreight_vol_share, seafreight_vol_share,freight_intensity,hcv_proj_total,veh,vehicles_per_pop,vehicles_per_hh,vkt_tot,vkt_per_veh,lite_average_fuel_efficiency_o,lite_alt_fuel_veh_shr_o,lite_alt_fuel_reg_shr_o , bus_proj_total, oil_price_proj_r,petrol_pump_price_proj_r,tax_tot_r,co2_total,nltf_real,net_nltf_real,ruc_real,fed_real)
	
    b = xl() 
	b.load_book("${Dir}/Output/${ScenarioOutputFN}")
	sheets = b.set_sheet("National")
	b.put_number(10,1,NatOutput)
	RegOutput = (Time_t',pop_by_reg,reg_gdp,veh_reg,veh_per_pop_by_reg, reg_vkt_proj,reg_pv_passkm_proj,reg_pt_passkm_proj,reg_pt_passengers_proj,reg_active_proj, reg_roadfreight_fcast)
	sheets = b.set_sheet("Regional")
	b.put_number(10,1,RegOutput)
	end
}

end
/*
	mata desc Time_t pop pop_workage households people_per_hh pop_dependent_ratio gdp_vol_fcast gdp_percapita lf_growth mfp_growth gdp_ind_vol_fcast freight_vol_fcast roadfreight_tkm_fcast railfreight_vol_share seafreight_vol_share freight_intensity hcv_proj_total veh vehicles_per_pop vkt_tot vkt_per_veh lite_average_fuel_efficiency_o lite_alt_fuel_veh_shr_o lite_alt_fuel_reg_shr_o  bus_proj_total oil_price_proj_r petrol_pump_price_proj_r tax_tot_r co2_total net_nltf_real ruc_real fed_real
	b.create_book($"${Dir}/Output/${ScenarioOutputFN}", "National")
	b.put_number(10,2,NatOutput)
	*/